package csci4534.controller;

/**
 * A page table entry. If the entry is valid, the remaining entry
 * contents describe the entry's page; if the entry is not valid, the
 * remaining entry contents should not be used. Similarly,
 *
 * <UL>
 *
 * <LI> Iff {@link #isInMemory()} is true, the page resides in memory
 * and {@link #getFrame()} returns the page's frame number.
 *
 * <P>
 *
 * <LI> Iff {@link #isOnDisk()} is true, the page resides on disk and
 * {@link #getBlock()} returns the page's disk block index.
 *
 * </UL>
 *
 * Note that a page may reside in memory and on disk at the same
 * time. This enables frames of clean (non-dirty) pages to be
 * immediately reclaimed (without a disk write) since their disk block
 * contains a current copy of the page; otherwise, the disk block's
 * contents may be outdated.
 *
 * @author Toli Lerios
 **/

public class PageTableEntry
{

    // INSTANCE DATA.

    private boolean mValid;
    private boolean mReferenced;
    private boolean mDirty;
    private boolean mInMemory;
    private int mFrame;
    private boolean mOnDisk;
    private int mBlock;


    // CONSTRUCTORS.

    /**
     * Creates a new entry.
     *
     * @param valid True iff the entry is a valid one.
     * @param referenced True iff the page was recently referenced.
     * @param dirty True iff the page was modified since it was last
     * written to disk.
     * @param inMemory True iff the page is stored in memory.
     * @param frame The page's memory frame number.
     * @param onDisk True iff the page is stored on disk.
     * @param block The page's disk block index.
     **/

    public PageTableEntry(boolean valid,
                          boolean referenced,
                          boolean dirty,
                          boolean inMemory,
                          int frame,
                          boolean onDisk,
                          int block)
    {
        setValid(valid);
        setReferenced(referenced);
        setDirty(dirty);
        setInMemory(inMemory);
        setFrame(frame);
        setOnDisk(onDisk);
        setBlock(block);
    }


    // PUBLIC INTERFACE.

    /**
     * Checks whether the entry is a valid one.
     *
     * @return True iff it is.
     **/

    public boolean isValid()
    {
        return mValid;
    }

    /**
     * Sets whether the entry is a valid one.
     *
     * @param valid True iff it is.
     **/

    public void setValid(boolean valid)
    {
        mValid=valid;
    }

    /**
     * Checks whether the page was recently referenced.
     *
     * @return True iff it was.
     **/

    public boolean isReferenced()
    {
        return mReferenced;
    }

    /**
     * Sets whether the page was recently referenced.
     *
     * @param referenced True iff it was.
     **/

    public void setReferenced(boolean referenced)
    {
        mReferenced=referenced;
    }

    /**
     * Checks whether the page was modified since it was last written
     * to disk.
     *
     * @return True iff it was.
     **/

    public boolean isDirty()
    {
        return mDirty;
    }

    /**
     * Sets whether the page was modified since it was last written to
     * disk.
     *
     * @param dirty True iff it was.
     **/

    public void setDirty(boolean dirty)
    {
        mDirty=dirty;
    }

    /**
     * Checks whether the page is stored in memory.
     *
     * @return True iff it is.
     **/

    public boolean isInMemory()
    {
        return mInMemory;
    }

    /**
     * Sets whether the page is stored in memory.
     *
     * @param inMemory True iff it is.
     **/

    public void setInMemory(boolean inMemory)
    {
        mInMemory=inMemory;
    }

    /**
     * Returns the page's memory frame number.  It is valid only if
     * the page is stored in memory.
     *
     * @return The frame number.
     **/

    public int getFrame()
    {
        return mFrame;
    }

    /**
     * Sets the page's memory frame number to the given value. It is
     * valid only if the page is stored in memory.
     *
     * @param frame The frame number.
     **/

    public void setFrame(int frame)
    {
        mFrame=frame;
    }

    /**
     * Checks whether the page is stored on disk.
     *
     * @return True iff it is.
     **/

    public boolean isOnDisk()
    {
        return mOnDisk;
    }

    /**
     * Sets whether the page is stored on disk.
     *
     * @param onDisk True iff it is.
     **/

    public void setOnDisk(boolean onDisk)
    {
        mOnDisk=onDisk;
    }

    /**
     * Returns the page's disk block index.  It is valid only if the
     * page is stored on disk.
     *
     * @return The block index.
     **/

    public int getBlock()
    {
        return mBlock;
    }

    /**
     * Sets the page's disk block index to the given value. It is
     * valid only if the page is stored on disk.
     *
     * @param block The block index.
     **/

    public void setBlock(int block)
    {
        mBlock=block;
    }
}
