package csci4534.controller;

/**
 * A process. It retains the segment descriptor table and page
 * directory, as well as the circular queue pointer for the
 * second-chance page replacement algorithm. This pointer is simple a
 * pair of indices (a page directory entry index and a page table
 * entry index) to a page table entry.
 * 
 * @author Toli Lerios
 **/

public class Process
{

    // INSTANCE DATA.

    private DescriptorTable mDescriptorTable;
    private PageDirectory mPageDirectory;
    private int mNextPDIndex;
    private int mNextPTIndex;


    // CONSTRUCTORS.

    /**
     * Creates a process.
     *
     * @param descriptorTable The descriptor table.
     * @param pageDirectory The page directory.
     * @param nextPDIndex The page directory portion of the queue
     * pointer.
     * @param nextPTIndex The page table portion of the queue pointer.
     **/

    public Process(DescriptorTable descriptorTable,
                   PageDirectory pageDirectory,
                   int nextPDIndex,
                   int nextPTIndex)
    {
        mDescriptorTable=descriptorTable;
        mPageDirectory=pageDirectory;
        setNextPDIndex(nextPDIndex);
        setNextPTIndex(nextPTIndex);
    }


    // PUBLIC INTERFACE.

    /**
     * Returns the descriptor table.
     *
     * @return The descriptor table.
     **/

    public DescriptorTable getDescriptorTable()
    {
        return mDescriptorTable;
    }

    /**
     * Returns the page directory.
     *
     * @return The page directory.
     **/

    public PageDirectory getPageDirectory()
    {
        return mPageDirectory;
    }

    /**
     * Returns the page directory portion of the queue pointer.
     *
     * @return The page directory entry index.
     **/

    public int getNextPDIndex()
    {
        return mNextPDIndex;
    }

    /**
     * Sets the page directory portion of the queue pointer to the
     * given value.
     *
     * @param nextPDIndex The new page directory entry index.
     **/

    public void setNextPDIndex(int nextPDIndex)
    {
        mNextPDIndex=nextPDIndex;
    }

    /**
     * Returns the page table portion of the queue pointer.
     *
     * @return The page table entry index.
     **/

    public int getNextPTIndex()
    {
        return mNextPTIndex;
    }

    /**
     * Sets the page table portion of the queue pointer to the given
     * value.
     *
     * @param nextPTIndex The new page table entry index.
     **/

    public void setNextPTIndex(int nextPTIndex)
    {
        mNextPTIndex=nextPTIndex;
    }
}
