package csci4534.controller;

/**
 * A segment descriptor. If the entry is valid, the remaining entry
 * data describe the entry's segment; if the entry is not valid, the
 * remaining entry data should not be used.
 * 
 * @author Toli Lerios
 **/

public class SegmentDescriptor
{

    // INSTANCE DATA.

    private boolean mValid;
    private boolean mReadable;
    private boolean mWriteable;
    private int mBase;
    private int mLimit;


    // CONSTRUCTORS.

    /**
     * Creates a new descriptor.
     *
     * @param valid True iff the entry is a valid one.
     * @param readable True iff data can be read from the segment.
     * @param writeable True iff data can be written into the segment.
     * @param base The segment's base address.
     * @param limit The segment's limit (length).
     **/

    public SegmentDescriptor(boolean valid,
                             boolean readable,
                             boolean writeable,
                             int base,
                             int limit)
    {
        setValid(valid);
        setReadable(readable);
        setWriteable(writeable);
        setBase(base);
        setLimit(limit);
    }


    // PUBLIC INTERFACE.

    /**
     * Checks whether the entry is a valid one.
     *
     * @return True iff it is.
     **/

    public boolean isValid()
    {
        return mValid;
    }

    /**
     * Sets whether the entry is a valid one.
     *
     * @param valid True iff it is.
     **/

    public void setValid(boolean valid)
    {
        mValid=valid;
    }

    /**
     * Checks whether data can be read from segment.
     *
     * @return True iff it can.
     **/

    public boolean isReadable()
    {
        return mReadable;
    }

    /**
     * Sets whether data can be read from segment.
     *
     * @param readable True iff it can.
     **/

    public void setReadable(boolean readable)
    {
        mReadable=readable;
    }

    /**
     * Checks whether data can be written into segment.
     *
     * @return True iff it can.
     **/

    public boolean isWriteable()
    {
        return mWriteable;
    }

    /**
     * Sets whether data can be written into segment.
     *
     * @param writeable True iff it can.
     **/

    public void setWriteable(boolean writeable)
    {
        mWriteable=writeable;
    }

    /**
     * Returns the segment's base address.
     *
     * @return The address.
     **/

    public int getBase()
    {
        return mBase;
    }

    /**
     * Sets the segment's base address to the given address.
     *
     * @param base The address.
     **/

    public void setBase(int base)
    {
        mBase=base;
    }

    /**
     * Returns the segment's limit.
     *
     * @return The limit.
     **/

    public int getLimit()
    {
        return mLimit;
    }

    /**
     * Sets the segment's limit to the given limit.
     *
     * @param limit The limit.
     **/

    public void setLimit(int limit)
    {
        mLimit=limit;
    }
}
