package csci4534.controller;

/**
 * Static utilities.
 *
 * @author Toli Lerios
 **/

public final class Utilities
{

    // PUBLIC INTERFACE.

    /**
     * Returns a bit mask containing a series of 0's (starting at the
     * most significant bit) followed by a series of 1's (all the way
     * to the least significant bit), where the number of 1's is
     * given.
     *
     * @param ones The number of 1's.
     *
     * @return The bit mask.
     **/

    public static int buildMask(int ones)
    {
        int result=0;
        for (int i=0;i<ones;i++) {
            result=((result<<1)|1);
        }
        return result;
    }

    /**
     * Returns the result of left-shifting <EM>n</EM> by <EM>s</EM>
     * bits and then computing the or of the result and <EM>l</EM>. If
     * <EM>l</EM>&lt;2<SUP><EM>s</EM></SUP>, then the result is
     * mathematically equivalent to
     * <EM>n</EM>*2<SUP><EM>s</EM></SUP>+<EM>l</EM>.
     *
     * @param n The first given integer. Must be non-negative.
     * @param s The given shift count.
     * @param l The second given integer. Must be non-negative.
     *
     * @return The result.
     **/

    public static int merge(int n,
                            int s,
                            int l)
    {
        return ((n<<s)|l);
    }

    /**
     * Returns the result of right-shifting <EM>n</EM> by <EM>s</EM>
     * bits and then applying a bit mask <EM>m</EM> to the result. If
     *
     * <UL>
     *
     * <LI> the mask contains a single block of 1's,
     *
     * <LI> the least significant 1 is at bit position 0 (the least
     * significant bit), and
     *
     * <LI> the least significant 0 is at bit position <EM>p</EM>,
     *
     * </UL>
     *
     * then the result is mathematically equivalent to (<EM>n</EM>
     * div 2<SUP><EM>s</EM></SUP>) mod 2<SUP><EM>p</EM></SUP>.
     *
     * @param n The given integer. Must be non-negative.
     * @param s The given shift count.
     * @param m The given bit mask.
     *
     * @return The result.
     **/

    public static int extract(int n,
                              int s,
                              int m)
    {
        return ((n>>s)&m);
    }

    /**
     * Returns 2<SUP><EM>n</EM></SUP>.
     *
     * @param n The given integer. Must be non-negative.
     *
     * @return The result.
     **/

    public static int pow2(int n)
    {
        return (1<<n);
    }

    /**
     * Returns the result of dividing <EM>n</EM> by
     * 2<SUP><EM>k</EM></SUP> and rounding up.
     *
     * @param n The given integer. Must be non-negative.
     * @param k The given exponent. Must be non-negative.
     * @param m A bit mask created via {@link #buildMask(int)} with
     * <EM>k</EM> as argument.
     *
     * @return The result.
     **/

    public static int div2Up(int n,
                             int k,
                             int m)
    {
        int result=(n>>k);
        if ((n&m)!=0) {
            result++;
        }
        return result;
    }
}
