package csci4534.controller;

// ADD CODE HERE IF APPROPRIATE.

import java.util.LinkedList;

/**
 * A memory controller with segmentation, paging, and virtual
 * memory. Available (free) disk blocks are maintained on a linked
 * list.
 *
 * <P>
 *
 * This controller uses on-demand paging and local frame
 * allocation. When a process allocates a segment, all its pages are
 * assigned disk blocks but no physical memory frames. As pages are
 * accessed, frames are allocated from the free frame list. If no free
 * frame is available, another page of the same process is swapped
 * out. The page replacement algorithm is a standard second-chance
 * algorithm approximating the LRU algorithm; we don't treat clean
 * pages preferentially.
 *
 * <P>
 *
 * Instead of having an actual linked list data structure to represent
 * the algorithm's circular queue, we traverse the process page
 * directory and page tables instead. Accordingly, the queue pointer
 * is a pair of indices:
 *
 * <UL>
 *
 * <LI> The first index <CODE>nextPDIndex</CODE> refers to a page
 * directory entry <EM>pde</EM> (via its index).
 *
 * <LI> The second index <CODE>nextPTIndex</CODE> refers to an entry
 * in the page table of <EM>pde</EM> (via its index).
 *
 * </UL>
 *
 * These two indices allow us to traverse the circular queue and
 * identify a victim page. The basic traversal is simple: keep
 * advancing <CODE>nextPTIndex</CODE> until we reach the end of a page
 * table (which is either after the last entry or at the first invalid
 * entry, whichever comes first); and, when we do, advance
 * <CODE>nextPDIndex</CODE> and move on to the next page
 * table. However, in practice, care must be taken to address the
 * following boundary cases correctly:
 *
 * <UL>
 *
 * <LI> Since we are moving around a circular queue, we must go back
 * to the beginning of the page directory when we reach the end, and
 * continue our search from there.
 *
 * <P>
 *
 * <LI> It is rare, but possible, for a process to have no pages in
 * memory when a page fault occurs. Since we are using local frame
 * allocation, this means no victim can be found. This may happen if,
 * for example, the first page fault of a process occurs while the
 * physical memory is full. Accordingly, care must be taken to avoid
 * infinite loops in our queue traversal; instead, we report a
 * failure, causing the memory access to fail as well. A real
 * operating system typically refuses to start a process if no memory
 * frames at all can be assigned to it; or, it simply blocks a process
 * with a failed memory access until memory frames become available,
 * and repeats the memory access when they do.
 *
 * <P>
 *
 * <LI> When we start our traverasl, it is possible for the index pair
 * to point to a page that has been deallocated (i.e. the
 * corresponding page directory entry or page table entry may not be
 * valid). In general, the pair is changed whenever a page fault
 * occurs; between page faults, the contents of the process page
 * directory and its page tables can change drastically.
 *
 * </UL>
 *
 * @author Toli Lerios
 **/

public class VirtualController
    extends PhysicalController
{

    // INSTANCE DATA.

    private Disk mDisk;
    private LinkedList mFreeBlocks=new LinkedList();
    private DMAController mDMAController;

    // ADD CODE HERE IF APPROPRIATE.


    // PRIVATE HELPERS.

    /**
     * Returns the system disk.
     *
     * @return The disk.
     **/

    private Disk getDisk()
    {
        return mDisk;
    }

    /**
     * Returns the system's DMA controller.
     *
     * @return The DMA controller.
     **/

    private DMAController getDMAController()
    {
        return mDMAController;
    }

    /**
     * Returns the index of a free block. It assumes one is
     * available. The returned block is removed from the free block
     * list.
     *
     * @return The block index.
     **/

    private int getFreeBlockUnsafe()
    {
        return ((Integer)(mFreeBlocks.removeFirst())).intValue();
    }

    /**
     * Adds a block to the free block list.
     *
     * @param block The block index.
     **/

    private void addFreeBlock(int block)
    {
        mFreeBlocks.addFirst(new Integer(block));
    }

    /**
     * Ensures that the given page table entry refers to a page that
     * is in memory. This check may trigger a page fault, which will
     * in turn trigger the controller's page replacement algorithm.
     *
     * @param process The process which owns the entry.
     * @param pte The entry.
     *
     * @throws ControllerException Thrown iff there is a controller
     * failure.
     **/

    private void ensureInMemory(Process process,
                                PageTableEntry pte)
        throws ControllerException
    {

        // ADD CODE HERE IF APPROPRIATE.

    }

    // ADD CODE HERE IF APPROPRIATE.


    // MemoryController.

    protected void ensureAdequateSpace(int pageCount)
        throws ControllerException
    {
        if (mFreeBlocks.size()<pageCount) {
            throw new ControllerException("Out of virtual memory");
        }
    }

    protected PageTableEntry mallocEntry()
    {
        return new PageTableEntry
            (true,false,false,false,0,true,getFreeBlockUnsafe());
    }

    protected void free(PageTableEntry pte)
    {
        // Release frame, if any.
        super.free(pte);
        // Release disk block, if any.
        if (pte.isOnDisk()) {
            addFreeBlock(pte.getBlock());
        }
    }

    protected void read(Process process,
                        AddressTranslation address)
        throws ControllerException
    {

        // ADD CODE HERE IF APPROPRIATE.

    }

    protected void write(Process process,
                         AddressTranslation address)
        throws ControllerException
    {

        // ADD CODE HERE IF APPROPRIATE.

    }

    public void initialize(ControllerConfiguration configuration,
                           Memory memory,
                           Disk disk,
                           DMAController controller)
    {
        super.initialize(configuration,memory,disk,controller);
        mDMAController=controller;
        mDisk=disk;
        // Initially, all of the disk contains free blocks.
        for (int i=getDisk().getCapacity();i>=0;i--) {
            addFreeBlock(i);
        }
    }
}
