package csci4534.allocator;

/**
 * A matrix whose rows are represented as instances of {@link Vector},
 * all with the same number of elements. Each row is identifiable via
 * its <EM>index</EM>, which is in the range [0,{@link
 * #getRowCount()}-1].
 *
 * @author Toli Lerios
 **/

public class Matrix
{

    // INSTANCE DATA.

    private Vector[] mRows;


    // CONSTRUCTORS.

    /**
     * Creates a matrix with the given number of rows. Each row is a
     * vector with the same, given, number of elements. All matrix
     * elements are initialized to 0.
     *
     * @param rowCount The number of rows.
     * @param colCount The number of elements per row.
     **/

    public Matrix(int rowCount,
                  int colCount)
    {
        mRows=new Vector[rowCount];
        for (int i=0;i<getRowCount();i++) {
            mRows[i]=new Vector(colCount);
        }
    }


    // PUBLIC INTERFACE.

    /**
     * Returns the matrix row at the given index.
     *
     * @param index The index.
     *
     * @return The row.
     **/

    public Vector get(int index)
    {
        return mRows[index];
    }

    /**
     * Returns the number of rows.
     *
     * @return The number of rows.
     **/

    public int getRowCount()
    {
        return mRows.length;
    }


    // Object.

    public String toString()
    {
        StringBuffer buffer=new StringBuffer();
        for (int i=0;i<getRowCount();i++) {
            if (i>0) {
                buffer.append(';');
            }
            buffer.append('(');
            buffer.append(get(i));
            buffer.append(')');
        }
        return buffer.toString();
    }
}
