package csci4534.allocator;

/**
 * A generic process participating in resource allocation.
 *
 * @author Toli Lerios
 **/

public interface Process
{

    /**
     * Returns the current resource allocations of the process. This
     * is a collection of pairs, where each pair contains a resource
     * and the number of instances of this resource currently
     * allocated to the process. This collection only contains a pair
     * for a resource iff the process has allocated at least one
     * instance of that resource; also, there are no two pairs in the
     * collection with the same resource.
     *
     * @return The resource allocations of the process. If the process
     * has allocated no instances of any resource, the result is an
     * empty collection, not <CODE>null</CODE>.
     **/

    public ResourceCount[] getAllocations();
}
