package csci4534.allocator;

/**
 * A table associating integer IDs (static or dynamic) with {@link
 * Process} implementations.
 *
 * @author Toli Lerios
 **/

public class ProcessTable
    extends IdTable
{

    // CONSTRUCTORS.

    /**
     * Creates a new process table.
     *
     * @param dynamic True iff process IDs should be dynamic.
     **/

    public ProcessTable(boolean dynamic)
    {
        super(dynamic);
    }


    // PUBLIC INTERFACE.

    /**
     * Adds the given process to the table, and assigns it a process
     * ID.
     *
     * @param process The process.
     *
     * @return The ID assigned to the process.
     **/

    public int put(Process process)
    {
        return super.putUntyped(process);
    }

    /**
     * Returns the process with the given ID.
     *
     * @param pid The process ID.
     *
     * @return The process.
     **/

    public Process get(int pid)
    {
        return (Process)getUntyped(pid);
    }

    /**
     * Returns the ID of the given process.
     *
     * @param process The process.
     *
     * @return The process ID.
     **/

    public int get(Process process)
    {
        return super.getUntyped(process);
    }

    /**
     * Checks whether the table contains the given process.
     *
     * @param process The process.
     *
     * @return True iff the table contains the given process.
     **/

    public boolean contains(Process process)
    {
        return super.containsUntyped(process);
    }

    /**
     * Removes the given process from the table.
     *
     * @param process The process.
     **/

    public void remove(Process process)
    {
        super.removeUntyped(process);
    }
}
