package csci4534.allocator;

/**
 * A de/allocation request by a process for one or more instances of
 * one or more resources.
 *
 * @author Toli Lerios
 **/

public class Request
{

    // INSTANCE DATA.

    private Process mProcess;
    private ResourceCount[] mResourceCount;


    // CONSTRUCTORS.

    /**
     * Creates a new request.
     *
     * @param process The requesting process.
     * @param resourceCount The requested resource instances.
     **/

    public Request(Process process,
                   ResourceCount[] resourceCount)
    {
        mProcess=process;
        mResourceCount=resourceCount;
    }


    // PUBLIC INTERFACE.

    /**
     * Returns the requesting process.
     *
     * @return The process.
     **/

    public Process getProcess()
    {
        return mProcess;
    }

    /**
     * Returns the requested resource instances.
     *
     * @return The instances.
     **/

    public ResourceCount[] getResourceCounts()
    {
        return mResourceCount;
    }
}
