package csci4534.allocator;

/**
 * A general-use pair of a resource and a count of (some of) its instances.
 *
 * @author Toli Lerios
 **/

public class ResourceCount
{

    // INSTANCE DATA.

    private Resource mResource;
    private int mInstances;


    // CONSTRUCTORS.

    /**
     * Creates a new pair.
     *
     * @param resource The resource.
     * @param instances The count of (some of) its instances.
     **/

    public ResourceCount(Resource resource,
                         int instances)
    {
        mResource=resource;
        mInstances=instances;
    }
    

    // PUBLIC INTERFACE.

    /**
     * Returns the resource part of the pair.
     *
     * @return The resource.
     **/

    public Resource getResource()
    {
        return mResource;
    }
    
    /**
     * Returns the instance count part of the pair.
     *
     * @return The instance count.
     **/

    public int getInstances()
    {
        return mInstances;
    }

    /**
     * Changes the instance count part of the pair by adding the given
     * number to it.
     *
     * @param instances The change in the instance count; a positive
     * number effects an increase, while a negative one effects a
     * reduction.
     **/

    public void changeInstances(int instances)
    {
        mInstances+=instances;
    }
}

