package csci4534.allocator;

/**
 * A table associating integer IDs (static or dynamic) with {@link
 * Resource} implementations.
 *
 * @author Toli Lerios
 **/

public class ResourceTable
    extends IdTable
{

    // CONSTRUCTORS.

    /**
     * Creates a new resource table.
     *
     * @param dynamic True iff resource IDs should be dynamic.
     **/

    public ResourceTable(boolean dynamic)
    {
        super(dynamic);
    }


    // PUBLIC INTERFACE.

    /**
     * Adds the given resource to the table, and assigns it a resource
     * ID.
     *
     * @param resource The resource.
     *
     * @return The ID assigned to the resource.
     **/

    public int put(Resource resource)
    {
        return super.putUntyped(resource);
    }

    /**
     * Returns the resource with the given ID.
     *
     * @param rid The resource ID.
     *
     * @return The resource.
     **/

    public Resource get(int rid)
    {
        return (Resource)getUntyped(rid);
    }

    /**
     * Returns the ID of the given resource.
     *
     * @param resource The resource.
     *
     * @return The resource ID.
     **/

    public int get(Resource resource)
    {
        return super.getUntyped(resource);
    }

    /**
     * Checks whether the table contains the given resource.
     *
     * @param resource The resource.
     *
     * @return True iff the table contains the given resource.
     **/

    public boolean contains(Resource resource)
    {
        return super.containsUntyped(resource);
    }

    /**
     * Removes the given resource from the table.
     *
     * @param resource The resource.
     **/

    public void remove(Resource resource)
    {
        super.removeUntyped(resource);
    }
}
