package csci4534.allocator;

/**
 * A vector with integer elements. Each element is identifiable via
 * its <EM>index</EM>, which is in the range [0,{@link #getSize()}-1].
 *
 * @author Toli Lerios
 **/

public class Vector
{

    // INSTANCE DATA.

    private int[] mData;


    // CONSTRUCTORS.

    /**
     * Creates a vector with the given number of elements, all
     * initialized to 0.
     *
     * @param size The number of elements.
     **/

    public Vector(int size)
    {
        mData=new int[size];
    }
    

    // PUBLIC INTERFACE.

    /**
     * Returns the element at the given index.
     *
     * @param index The index.
     *
     * @return The element.
     **/

    public int get(int index)
    {
        return mData[index];
    }

    /**
     * Sets the element at the given index to the given value
     *
     * @param index The index.
     * @param value The value.
     **/

    public void set(int index,
                    int value)
    {
        mData[index]=value;
    }

    /**
     * Returns the number of elements.
     *
     * @return The number of elements.
     **/

    public int getSize()
    {
        return mData.length;
    }

    /**
     * Adds the elements of the given vector to the receiver; the
     * result is stored in the receiver. Throws an {@link
     * IllegalArgumentException} (a run-time exception) if the two
     * vectors have a different number of elements.
     *
     * @param v The vector to be added to the receiver.
     **/

    public void add(Vector v)
    {

        // ADD CODE HERE IF APPROPRIATE.

    }

    /**
     * Checks whether the elements of the receiver are all no larger
     * than the corresponding elements in the given vector. Throws an
     * {@link IllegalArgumentException} (a run-time exception) if the
     * two vectors have a different number of elements.
     *
     * @param v The vector to be compared to the receiver.
     *
     * @return True iff all elements of the receiver are no larger
     * than the corresponding elements in the given vector.
     **/

    public boolean isLTE(Vector v)
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return true;
    }

    /**
     * Checks whether the vector elements are all 0.
     *
     * @return True iff they are.
     **/

    public boolean isZero()
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return true;
    }


    // Object.

    public String toString()
    {
        StringBuffer buffer=new StringBuffer();
        for (int i=0;i<getSize();i++) {
            if (i>0) {
                buffer.append(',');
            }
            buffer.append(get(i));
        }
        return buffer.toString();
    }
}
